/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigExposedFieldTableModel;
import filenet.vw.toolkit.admin.property.base.VWConfigStatusRender;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWFieldNameSelectorDialog;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigExposedFieldPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSystemConfiguration m_vwSysConfig = null;
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_tableDef = null;
    private int m_workItemsInQueue = 0;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_fieldTable = null;
    private VWConfigExposedFieldTableModel m_fieldTableModel = null;
    private int m_dbType;

    public VWConfigExposedFieldPanel(Frame parent, VWSystemConfiguration sysConfig, int dbType, IVWTableDefinition tableDef, int itemsInQueue) {
        try {
            this.m_parentFrame = parent;
            this.m_vwSysConfig = sysConfig;
            this.m_dbType = dbType;
            this.m_tableDef = tableDef;
            this.m_workItemsInQueue = itemsInQueue;
            this.createControls(VWResource.DataFields, 0x10000004);
            this.m_fieldTable.clearSelection();
            this.m_fieldTable.setRowSelectionInterval(0, 0);
            this.m_fieldTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this, parent, VWResource.DataFieldsPanel, VWResource.DataFieldsPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        if (this.m_fieldTableModel != null) {
            return this.m_fieldTableModel.isModified();
        }
        return false;
    }

    public void stopEditing() {
        if (this.m_fieldTable != null) {
            this.m_fieldTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 1: {
                this.updateTableSelection(event.getLastRow() - 1, true);
                break;
            }
            case -1: {
                this.updateTableSelection(event.getLastRow() - 1, false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowIndex = this.m_fieldTable.getSelectedRow();
            String name = (String)this.m_fieldTableModel.getValueAt(nRowIndex, 1);
            if (name == null || name.length() == 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4));
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        int nRowIndex = -1;
        try {
            nRowIndex = this.m_fieldTable.getSelectedRow();
            if (nRowIndex == -1) {
                return;
            }
            switch (event.getID()) {
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 4: {
                    this.onExposedFields();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_vwSysConfig = null;
        this.m_parentFrame = null;
        this.m_tableDef = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseResources();
            this.m_toolBarBorder = null;
        }
        if (this.m_fieldTable != null) {
            this.m_fieldTable.removeAll();
            this.m_fieldTable = null;
        }
        if (this.m_fieldTableModel != null) {
            this.m_fieldTableModel.releaseResources();
            this.m_fieldTableModel = null;
        }
        this.removeAll();
    }

    private void createControls(String description, int nFlags) {
        JPanel panel = null;
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_toolBarBorder = new VWToolbarBorder(description, nFlags);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this, description, description);
            this.createFieldTable();
            VWAccessibilityHelper.setAccessibility(this.m_fieldTable, this, description, description);
            JLabel label = new JLabel(description);
            VWAccessibilityHelper.setAccessibility(label, this, description, description);
            VWAccessibilityHelper.setLabelFor(label, this.m_fieldTable);
            label = new JLabel(VWResource.DataFieldsTableHeader);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.DataFieldsTableHeader, VWResource.DataFieldsTableHeader);
            VWAccessibilityHelper.setLabelFor(label, this.m_fieldTable.getTableHeader());
            panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_fieldTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_fieldTable, panel, VWResource.DataFieldsTable, VWResource.DataFieldsTable);
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createFieldTable() {
        int nColWidth = 0;
        try {
            this.m_fieldTableModel = new VWConfigExposedFieldTableModel(this.m_parentFrame, this.m_tableDef, this.m_workItemsInQueue);
            this.m_fieldTableModel.addTableModelListener(this);
            this.m_fieldTable = new VWTable(this.m_fieldTableModel);
            this.m_fieldTable.setRowSelectionAllowed(true);
            this.m_fieldTable.getSelectionModel().addListSelectionListener(this);
            this.m_fieldTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_fieldTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_fieldTable.getColumnModel().getColumn(0);
            try {
                nColWidth = Integer.valueOf("20");
            }
            catch (Exception ex) {
                nColWidth = 20;
            }
            aColumn.setMaxWidth(nColWidth);
            aColumn.setCellRenderer(new VWConfigStatusRender(0));
            aColumn = this.m_fieldTable.getColumnModel().getColumn(1);
            try {
                nColWidth = Integer.valueOf("250");
            }
            catch (Exception ex) {
                nColWidth = 250;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn = this.m_fieldTable.getColumnModel().getColumn(2);
            aColumn.setCellEditor(new DefaultCellEditor(this.m_fieldTableModel.getFieldTypeComboBox()));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.m_fieldTable.stopEditing();
            int[] rows = this.m_fieldTable.getSelectedRows();
            int sz = rows.length;
            if (sz > 1) {
                for (int nIndex = sz - 1; nIndex >= 0; --nIndex) {
                    int ret = 0;
                    if (!bYesToAll) {
                        Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                        String fieldName = (String)this.m_fieldTableModel.getValueAt(rows[nIndex], 1);
                        ret = JOptionPane.showOptionDialog(this.m_parentFrame, VWResource.ConfirmDeleteField.toString(fieldName), null, -1, 3, null, options1, options1[1]);
                        if (ret == 1) {
                            bYesToAll = true;
                        }
                    }
                    if (ret != 0 && !bYesToAll) continue;
                    this.m_fieldTableModel.deleteItem(rows[nIndex]);
                }
            } else {
                String fieldName;
                VWExposedFieldDefinition fieldDef = this.m_fieldTableModel.getFieldItemAt(rows[0]);
                if (fieldDef != null && VWMessageDialog.showConfirmDialog(this.m_parentFrame, VWResource.ConfirmDeleteField.toString(fieldName = fieldDef.getName()), VWResource.ConfirmDeleteField.toString(fieldName), 3) == 1) {
                    this.m_fieldTableModel.deleteItem(rows[0]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onExposedFields() {
        try {
            int rowCount = this.m_fieldTable.getRowCount();
            Vector<VWExposedFieldDefinition> names = new Vector<VWExposedFieldDefinition>();
            for (int nIndex = 0; nIndex < rowCount; ++nIndex) {
                VWExposedFieldDefinition fieldDef = this.m_fieldTableModel.getFieldItemAt(nIndex);
                if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0) continue;
                names.addElement(fieldDef);
            }
            VWFieldNameSelectorDialog dlg = new VWFieldNameSelectorDialog(this.m_parentFrame, this.m_vwSysConfig, names, true);
            dlg.setVisible(true);
            if (!dlg.getStatus()) {
                Object[] items = dlg.getSelectedDataFields();
                rowCount = this.m_fieldTable.getRowCount();
                for (int nIndex = rowCount - 1; nIndex >= 0; --nIndex) {
                    VWExposedFieldDefinition fieldDef = this.m_fieldTableModel.getFieldItemAt(nIndex);
                    if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0 || this.isInList(fieldDef, items)) continue;
                    this.m_fieldTableModel.deleteItem(nIndex);
                }
                for (int i = 0; i < items.length; ++i) {
                    boolean found = false;
                    VWDataFieldItem item = (VWDataFieldItem)items[i];
                    rowCount = this.m_fieldTable.getRowCount();
                    for (int nIndex = 0; nIndex < rowCount; ++nIndex) {
                        VWExposedFieldDefinition fieldDef = this.m_fieldTableModel.getFieldItemAt(nIndex);
                        if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0 || VWStringUtils.compare(fieldDef.getName(), item.getName()) != 0 || fieldDef.getFieldType() != item.getType()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.m_fieldTableModel.addItem(items[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean isInList(VWExposedFieldDefinition fieldDef, Object[] lists) {
        if (lists != null) {
            for (int i = 0; i < lists.length; ++i) {
                VWDataFieldItem item;
                if (!(lists[i] instanceof VWDataFieldItem) || (item = (VWDataFieldItem)lists[i]) == null || VWStringUtils.compare(fieldDef.getName(), item.getName()) != 0 || fieldDef.getFieldType() != item.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private void updateTableSelection(int nRow, boolean bInsert) {
        if (nRow < 0) {
            nRow = 0;
        }
        if (nRow == this.m_fieldTable.getSelectedRow()) {
            this.m_fieldTable.clearSelection();
        }
        this.m_fieldTable.setRowSelectionInterval(nRow, nRow);
        if (bInsert) {
            this.m_fieldTable.ensureRowIsVisible(nRow);
        }
    }
}

